package app.firezone.synk.network.Activities;

import androidx.appcompat.app.AppCompatActivity;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;


import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.R;
import app.firezone.synk.network.databinding.ActivityAddMoneyBinding;
import app.firezone.synk.network.model.ApiResponse;
import app.firezone.synk.network.model.PaymentModel;
import app.firezone.synk.network.model.User;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

import java.util.ArrayList;

public class Add_Money_Activity extends AppCompatActivity {

    EditText enterAmount;
    String userMobile = "", apiKey = "", depoCurentCoin = "";
    Dialog dialog;
    MyApi myApi;
    long minDeposit = 0;
    ActivityAddMoneyBinding binding;
    TextView availBalance;

    @SuppressLint("MissingInflatedId")
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = ActivityAddMoneyBinding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());

        // API initialization
        myApi = APIClient.getApiClient(getApplicationContext()).create(MyApi.class);

        // Set back button
        binding.backArrow.setOnClickListener(v -> finish());

        // Get amount input field
        enterAmount = binding.enterAmount;

        // Initially disable button until data loads
        binding.addMoneyBtn.setEnabled(false);

        // Loading dialog setup
        dialog = new Dialog(Add_Money_Activity.this);
        dialog.setContentView(R.layout.loading_dialog);
        if (dialog.getWindow() != null) {
            dialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        }
        dialog.setCancelable(false);
        dialog.show();

        // Load data
        loadUserData();         // If needed to get userMobile
        setMinimumWithdrawal(); // To fetch apiKey and minDeposit

        binding.hundred.setOnClickListener(view -> {
            enterAmount.setText("100");
        });

        binding.fifty.setOnClickListener(view -> {
            enterAmount.setText("50");
        });

        binding.ten.setOnClickListener(view -> {
            enterAmount.setText("10");
        });

        // Add money button listener
        binding.addMoneyBtn.setOnClickListener(view -> {

            String enter_amount = enterAmount.getText().toString().trim();

            if (TextUtils.isEmpty(enter_amount)) {
                enterAmount.setError("Enter any amount");
                Toast.makeText(this, "Enter Amount", Toast.LENGTH_SHORT).show();
                return;
            }

            int enteredAmount = Integer.parseInt(enter_amount);

            if (enteredAmount < minDeposit) {
                enterAmount.setError("Add Minimum ₹" + minDeposit);
                Toast.makeText(this, "Add Minimum ₹" + minDeposit, Toast.LENGTH_SHORT).show();
                return;
            }

            if (apiKey == null || apiKey.isEmpty()) {
                Toast.makeText(this, "Wait... Api Key not loaded yet", Toast.LENGTH_SHORT).show();
                return;
            }

            // ✅ Send data to next activity
            Intent intent = new Intent(Add_Money_Activity.this, CashupiActivity.class);
            intent.putExtra("amount", String.valueOf(enteredAmount));
            intent.putExtra("Phoneno", userMobile);
            intent.putExtra("apiKey", apiKey);
            startActivity(intent);
            finish();
        });
    }

    // Fetch minDeposit and apiKey from API
    private void setMinimumWithdrawal() {
        Call<ArrayList<PaymentModel>> call = myApi.fetchPaymentSetting();

        call.enqueue(new Callback<ArrayList<PaymentModel>>() {
            @Override
            public void onResponse(Call<ArrayList<PaymentModel>> call, Response<ArrayList<PaymentModel>> response) {
                dialog.dismiss(); // Close loading dialog

                if (response.isSuccessful() && response.body() != null && !response.body().isEmpty()) {
                    PaymentModel model = response.body().get(0);

                    // ✅ Correctly set to class variable
                    minDeposit = model.getMinDeposit();
                    apiKey = model.getApikey();

                    // Enable button now
                    binding.addMoneyBtn.setEnabled(true);

                    // Optional debug logs
                    Log.d("AddMoney", "ApiKey Loaded: " + apiKey);
                    Log.d("AddMoney", "MinDeposit Loaded: " + minDeposit);
                } else {
                    Toast.makeText(Add_Money_Activity.this, "Failed to fetch payment settings", Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<ArrayList<PaymentModel>> call, Throwable throwable) {
                dialog.dismiss();
                Toast.makeText(Add_Money_Activity.this, "Error: " + throwable.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });
    }


    private void loadUserData() {
        long userId = SharedPrefManager.getInstance(Add_Money_Activity.this).getUserId();

        if (userId == -1) {
            Toast.makeText(Add_Money_Activity.this, "User not found. Please log in again.", Toast.LENGTH_SHORT).show();
            startActivity(new Intent(Add_Money_Activity.this, LoginActivity.class));
            finish();
            return;
        }

        myApi = APIClient.getApiClient(getApplicationContext()).create(MyApi.class);
        Call<ApiResponse> call = myApi.fetchProfileData(userId);

        call.enqueue(new Callback<ApiResponse>() {
            @Override
            public void onResponse(Call<ApiResponse> call, Response<ApiResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    ApiResponse apiResponse = response.body();
                    if (apiResponse.getStatus() == 200 && apiResponse.getUser() != null) {
                        User model = apiResponse.getUser();

                        userMobile = model.getPhoneno();

                    } else {
                        Toast.makeText(Add_Money_Activity.this, apiResponse.getMessage(), Toast.LENGTH_SHORT).show();
                    }
                } else {
                    Toast.makeText(Add_Money_Activity.this, "Failed to load user data", Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<ApiResponse> call, Throwable t) {
                Toast.makeText(Add_Money_Activity.this, "Something went wrong. Try again later.", Toast.LENGTH_SHORT).show();

            }
        });

    }


}